package com.qboxus.tictic.activitesfragments

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.AbsListView
import androidx.activity.result.contract.ActivityResultContracts.StartActivityForResult
import androidx.databinding.DataBindingUtil
import androidx.fragment.app.Fragment
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.SimpleItemAnimator
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.search.SearchMainActivity
import com.qboxus.tictic.activitesfragments.shoping.ShopF
import com.qboxus.tictic.adapters.DiscoverAdapter
import com.qboxus.tictic.adapters.SlidingAdapter
import com.qboxus.tictic.apiclasses.ApiLinks
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.databinding.FragmentDiscoverBinding
import com.qboxus.tictic.models.DiscoverModel
import com.qboxus.tictic.models.HomeModel
import com.qboxus.tictic.models.SliderModel
import com.qboxus.tictic.repositories.VideosRepository
import com.qboxus.tictic.simpleclasses.DataHolder
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Functions.checkStatus
import com.qboxus.tictic.simpleclasses.Functions.getHeaders
import com.qboxus.tictic.simpleclasses.Variables
import com.qboxus.tictic.viewModels.DiscoverFactory
import com.qboxus.tictic.viewModels.DiscoverViewModel
import com.volley.plus.VPackages.VolleyRequest
import org.json.JSONObject


class DiscoverFragment : Fragment(), View.OnClickListener {

    var datalist = mutableListOf<DiscoverModel>()
    var adapter: DiscoverAdapter? = null
    var linearLayoutManager: LinearLayoutManager? = null
    var parentPostion = 0
    lateinit var binding: FragmentDiscoverBinding
    var isSliderApiCall: Boolean = false


    lateinit var viewModel: DiscoverViewModel
    private val videoRepository = VideosRepository()

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        // Inflate the layout for this fragment
        binding = DataBindingUtil.inflate(inflater, R.layout.fragment_discover, container, false)


        linearLayoutManager = LinearLayoutManager(binding.root.context)
        linearLayoutManager!!.orientation = RecyclerView.VERTICAL
        binding.recylerview.layoutManager = linearLayoutManager
        binding.recylerview.setHasFixedSize(true)
        (binding.recylerview.itemAnimator as SimpleItemAnimator?)!!.supportsChangeAnimations = false

        val json = Functions.getSharedPreference(binding.root.context).getString("showDiscoverySections", "")
        if (!TextUtils.isEmpty(json)) {
            val type = object : TypeToken<ArrayList<DiscoverModel>?>() {}.type
            val gson = Gson()
            datalist= gson.fromJson(json, type)
        }

        adapter = DiscoverAdapter(
            binding.root.context,
            datalist, object: DiscoverAdapter.OnItemClickListener{
                override fun onItemClick(
                    view: View?,
                    video_list: ArrayList<HomeModel?>,
                    main_position: Int,
                    child_position: Int
                ) {
                    parentPostion = main_position
                    if (view?.id == R.id.hashtag_layout || video_list[child_position] == null) {
                        openHashtag(datalist!![main_position].title)
                    } else {
                        openWatchVideo(child_position, video_list, datalist!![main_position].title)
                    }
                }
            })
        binding.recylerview.adapter = adapter

        binding.recylerview.addOnScrollListener(object :
            RecyclerView.OnScrollListener() {
            var userScrolled = false
            var scrollOutitems = 0
            var scrollInItem = 0
            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)
                if (newState == AbsListView.OnScrollListener.SCROLL_STATE_TOUCH_SCROLL) {
                    userScrolled = true
                }
            }

            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                scrollInItem = linearLayoutManager!!.findFirstVisibleItemPosition()
                scrollOutitems = linearLayoutManager!!.findLastVisibleItemPosition()

                if (userScrolled && scrollOutitems == datalist!!.size - 1) {
                    userScrolled = false
                    if (viewModel.loadMoreProgressVisibility.get() ==false && !viewModel.ispostFinsh) {
                        viewModel.loadMoreProgressVisibility.set(true)
                        viewModel.pageCount.set(viewModel.pageCount.get()+1)
                        viewModel.showDiscoverySections()
                    }
                }
            }
        })
        binding.searchLayout.setOnClickListener(this)
        binding.searchEdit.setOnClickListener(this)
        binding.shopBtn.setOnClickListener(this)


        return binding.getRoot()
    }

    // get the image of the upper slider in the discover screen
    private fun callApiSlider() {
        if (isSliderApiCall) {
            return
        }
        isSliderApiCall = true

        VolleyRequest.JsonPostRequest(
            activity, ApiLinks.showAppSlider, JSONObject(), getHeaders(
                activity
            )
        ) { resp ->
            checkStatus(activity, resp)
            isSliderApiCall = false
            parseSliderData(resp)
        }
    }


    var slider_list: java.util.ArrayList<SliderModel> = java.util.ArrayList()
    fun parseSliderData(resp: String?) {
        try {
            val jsonObject = JSONObject(resp)

            val code = jsonObject.optString("code")
            if (code == "200") {
                slider_list.clear()

                val msg = jsonObject.optJSONArray("msg")
                for (i in 0 until msg.length()) {
                    val `object` = msg.optJSONObject(i)
                    val AppSlider = `object`.optJSONObject("AppSlider")

                    val sliderModel = SliderModel()
                    sliderModel.id = AppSlider.optString("id")
                    sliderModel.image = AppSlider.optString("image")
                    sliderModel.url = AppSlider.optString("url")

                    slider_list.add(sliderModel)
                }

                setSliderAdapter()
            }
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }


    fun setSliderAdapter() {
        binding.pageIndicatorView.setCount(slider_list.size)
        binding.pageIndicatorView.setSelection(0)

        binding.viewPager.setAdapter(SlidingAdapter(
            activity, slider_list
        ) { view, pos, `object` ->
            val slider_url = slider_list[pos].url
            if (slider_url != null && slider_url != "") {
                val intent = Intent(view.context, WebviewActivity::class.java)
                intent.putExtra("url", slider_url)
                intent.putExtra("title", "Link")
                startActivity(intent)
                requireActivity().overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
            }
        })

        binding.pageIndicatorView.setViewPager(binding.viewPager)
    }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val viewModelProviderFactory = DiscoverFactory(binding.root.context,videoRepository)
        viewModel = ViewModelProvider(this,viewModelProviderFactory)[DiscoverViewModel::class.java]
        binding.viewModel = viewModel
        binding.lifecycleOwner = viewLifecycleOwner

        setObserveAble()

    }

    override fun setMenuVisibility(menuVisible: Boolean) {
        super.setMenuVisibility(menuVisible)
        if(::binding.isInitialized && menuVisible){
            callApiSlider()
            viewModel.showDiscoverySections()
        }
    }

    fun setObserveAble(){

        viewModel.videosLiveData.observe(viewLifecycleOwner,{
            when(it){
                is ApiResponce.Loading ->{

                    if(viewModel.pageCount.get()==0 && datalist?.isEmpty() == true) {
                        binding.shimmerLayout.shimmerViewContainer.startShimmer()
                        binding.shimmerLayout.shimmerViewContainer.visibility = View.VISIBLE
                    }else{
                        binding.shimmerLayout.shimmerViewContainer.stopShimmer()
                        binding.shimmerLayout.shimmerViewContainer.visibility = View.GONE
                    }
                }

                is ApiResponce.Success ->{
                    it.data?.let {
                        if (viewModel.pageCount.get() == 0) {
                            datalist!!.clear()
                            saveArrayList(it)
                        }
                        datalist!!.addAll(it)
                        changeUi()
                    }

                }

                is ApiResponce.Error ->{
                    changeUi()
                }

            }
        })

    }


    fun changeUi(){
        if (datalist!!.isEmpty()) {
            viewModel.showNoDataView()
        } else {
            viewModel.showDataView()
        }
        adapter?.notifyDataSetChanged()
        binding.shimmerLayout.shimmerViewContainer.stopShimmer()
        binding.shimmerLayout.shimmerViewContainer.visibility = View.GONE

        viewModel.loadMoreProgressVisibility.set(false)
    }


    fun saveArrayList(list: ArrayList<DiscoverModel>?) {
        val gson = Gson()
        val json = gson.toJson(list)
        Functions.getSharedPreference(getContext()).edit().putString("showDiscoverySections", json)
            .apply()
    }

    // When you click on any Video a new activity is open which will play the Clicked video
    private fun openWatchVideo(postion: Int, data_list: ArrayList<HomeModel?>, hashtag: String) {
        if (data_list.size > 5) data_list.removeAt(data_list.size - 1)
        val intent = Intent(binding.root.context, WatchVideosActivity::class.java)

        val args = Bundle()
        args.putSerializable("arraylist", data_list)
        DataHolder.instance?.data = args

        intent.putExtra("position", postion)
        intent.putExtra("pageCount", 0)
        intent.putExtra("hashtag", hashtag)
        intent.putExtra(
            "userId",
            Functions.getSharedPreference(binding.root.context).getString(Variables.U_ID, "")
        )
        intent.putExtra("whereFrom", "discoverTagedVideo")
        try {
            resultCallback.launch(intent)
        }catch (e:Exception){
            startActivity(intent)
        }
    }

    var resultCallback = registerForActivityResult(
        StartActivityForResult()
    ) { result ->
        if (result.resultCode == Activity.RESULT_OK) {
            val data = result.data
            if (data!!.getBooleanExtra("isShow", false)) {
                try {
                    val itemUpdate = datalist!![parentPostion]
                    val datalist1 = itemUpdate.arrayList
                    if (datalist1.size >= 5) datalist1.add(null)
                    itemUpdate.arrayList = datalist1
                    datalist!![parentPostion] = itemUpdate
                    adapter?.notifyItemChanged(parentPostion)
                    viewModel.pageCount.set(data.getIntExtra("pageCount", 0))
                } catch (e: Exception) {
                    Functions.printLog(Constants.tag, "Exception: $e")
                }
            }
        }
    }

    fun openSearch() {
        val intent = Intent(binding.root.context, SearchMainActivity::class.java)
        startActivity(intent)
        requireActivity().overridePendingTransition(R.anim.fade_in, R.anim.fade_out)
    }

    private fun openHashtag(tag: String) {
        val intent = Intent(binding.root.context, TagedVideosActivity::class.java)
        intent.putExtra("tag", tag)
        startActivity(intent)
        requireActivity().overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.search_layout -> openSearch()
            R.id.search_edit -> openSearch()
            R.id.back_btn -> requireActivity().onBackPressed()

            R.id.shopBtn ->openShop()

            else -> return
        }
    }

    private fun openShop() {
        val shopF = ShopF.newInstance()
        val ft = requireActivity().supportFragmentManager.beginTransaction()
        ft.setCustomAnimations(
            R.anim.in_from_right,
            R.anim.out_to_left,
            R.anim.in_from_left,
            R.anim.out_to_right
        )
        ft.replace(R.id.mainMenuFragment, shopF, "ShopF").addToBackStack("ShopF").commit()
    }

    companion object {
        fun newInstance(): DiscoverFragment {
            val fragment = DiscoverFragment()
            val args = Bundle()
            fragment.arguments = args
            return fragment
        }
    }


}
